Imports System
Imports System.Drawing
Imports System.Windows.Forms

Module MainModule

  Sub Main
    Dim f As New CMainForm
    f.ShowDialog()
  End Sub
	
  Public Class CMainForm
    Inherits System.Windows.Forms.Form

    Dim timer As Timer

    Public Sub New
      MyBase.New()

      timer          = new Timer
      timer.Interval = 50 
      AddHandler timer.Tick, AddressOf Timer_Tick 

      timer.Start

      SetStyle(ControlStyles.UserPaint, True)
      SetStyle(ControlStyles.AllPaintingInWmPaint, True)
      SetStyle(ControlStyles.DoubleBuffer, True)
    End Sub

    Sub Timer_Tick( sender As Object, e As EventArgs )
      Me.Invalidate
    End Sub

    Protected Overrides Sub OnPaint( e As PaintEventArgs )
      Dim g as Graphics = e.Graphics
      Dim f as Font     = new Font( "LED", 48 )

      Dim sf as StringFormat = new StringFormat()

      sf.Alignment     = StringAlignment.Center
      sf.LineAlignment = StringAlignment.Center

      g.Clear( SystemColors.Control )
      g.DrawString( DateTime.Now.ToLongTimeString(), f, Brushes.Black, _
          Me.Width / 2, Me.Height / 2, sf )


     End Sub
		
  End Class
	
End Module 
